# Hotel Noesis - Luxury Hotel Website

A premium, production-ready luxury hotel website built with pure HTML5, CSS3, and vanilla JavaScript. Features sophisticated design, smooth animations, responsive layout, and comprehensive functionality.

## 🌟 Overview

Hotel Noesis is a multi-page luxury hospitality website showcasing refined elegance through:
- **Timeless Design**: Editorial-inspired luxury aesthetic with gold (#bd9a41) accent color
- **Premium Typography**: Cormorant Garamond display font paired with Montserrat body text
- **Sophisticated Interactions**: Smooth animations, scroll effects, and micro-interactions
- **Full Responsiveness**: Mobile-first design with seamless tablet and desktop experiences

## 📁 Project Structure

```
/
├── index.html                 # Home page - hero, highlights, dining preview
├── css/
│   └── styles.css            # Complete design system with CSS variables
├── js/
│   └── main.js               # All interactions and animations
├── images/
│   └── noesis_logo.png       # Brand logo
├── pages/
│   ├── eats.html             # Dining overview
│   ├── ntangaza.html         # African cuisine restaurant
│   ├── solari.html           # Mediterranean restaurant
│   ├── grove-pit.html        # Fire & smoke restaurant
│   ├── stay.html             # Accommodations with room categories
│   ├── wellness.html         # Spa and fitness facilities
│   ├── services.html         # Hotel amenities and services
│   ├── travel-info.html      # Directions and local attractions
│   ├── contact.html          # Contact form with validation
│   └── terms.html            # Terms and conditions
└── README.md                  # This file
```

## 🎨 Design System

### Color Palette
- **Gold Primary**: `#bd9a41` - Brand accent, CTAs, highlights
- **Gold Light**: `#d4b76a` - Hover states, accents
- **Charcoal**: `#1a1a1a` - Primary text, dark backgrounds
- **Warm Charcoal**: `#2d2d2d` - Secondary backgrounds
- **Ivory**: `#faf8f5` - Primary light background
- **Champagne**: `#f5f1e8` - Alternate light background
- **Bronze**: `#8b7355` - Muted accents
- **Forest Green**: `#1f2d23` - Depth accents

### Typography
- **Display Font**: Cormorant Garamond (Google Fonts)
- **Body Font**: Montserrat (Google Fonts)
- **Accent Font**: Playfair Display (Google Fonts)
- **Fluid Typography**: CSS clamp() for responsive sizing

### Spacing Scale
CSS custom properties provide consistent spacing:
- `--space-xs` to `--space-4xl` (0.5rem to 8rem)
- Responsive adjustments via media queries

## ✨ Features

### Navigation
- **Fixed Header**: Transparent on load, solid background on scroll
- **Mobile Menu**: Smooth slide-in hamburger menu
- **Active States**: Current page highlighting
- **Smooth Transitions**: All nav interactions use CSS transitions

### Animations & Interactions
- **Scroll Animations**: Intersection Observer API for fade-in effects
- **Parallax Hero**: Subtle parallax on hero background images
- **Staggered Reveals**: Sequential animation delays for cards
- **Hover Effects**: Sophisticated hover states on buttons, cards, images
- **Form Validation**: Real-time JavaScript validation with error messages

### Components
- **Hero Sections**: Full-screen with overlay and centered content
- **Cards**: Hover effects with image zoom and shadow lift
- **Buttons**: Primary, outline, and dark variants with hover animations
- **Forms**: Validated contact form with custom error handling
- **Lightbox**: Click images to view in fullscreen modal
- **Footer**: Comprehensive multi-column layout with links

### JavaScript Functionality
1. **Header Scroll Effect**: Changes appearance on scroll
2. **Mobile Menu Toggle**: Smooth hamburger menu animation
3. **Intersection Observer**: Triggers scroll animations
4. **Smooth Scrolling**: For anchor links
5. **Lightbox Gallery**: Click-to-expand image viewer
6. **Form Validation**: Real-time validation with custom messages
7. **Lazy Loading**: Images load as they enter viewport
8. **Parallax Effect**: Smooth parallax on hero backgrounds

## 🚀 Getting Started

### Installation
1. Clone or download this repository
2. No build process required - it's pure HTML/CSS/JS!
3. Open `index.html` in a web browser

### Running Locally
Simply open `index.html` in any modern web browser. For best results:
- Use Chrome, Firefox, Safari, or Edge (latest versions)
- For local development, consider using a simple HTTP server:
  ```bash
  # Python 3
  python -m http.server 8000

  # Node.js (with http-server)
  npx http-server
  ```

### Deployment
Upload all files to your web hosting:
1. Maintain the folder structure exactly as shown
2. Ensure all file paths are correct (images, CSS, JS)
3. No compilation or build step required

## 📱 Responsive Breakpoints

```css
/* Desktop: Default styles */
/* Tablet: max-width: 1024px */
/* Mobile: max-width: 768px */
/* Small Mobile: max-width: 480px */
```

Mobile-first approach with progressive enhancement for larger screens.

## 🛠️ Customization

### Changing Colors
Edit CSS custom properties in `css/styles.css`:
```css
:root {
  --gold-primary: #bd9a41;  /* Change your brand color */
  --charcoal: #1a1a1a;      /* Adjust text color */
  /* etc. */
}
```

### Updating Content
- **Text**: Edit HTML files directly
- **Images**: Replace Unsplash URLs with your own image paths
- **Logo**: Replace `images/noesis_logo.png` with your logo

### Adding Pages
1. Copy an existing page from `/pages`
2. Update navigation links in header
3. Maintain consistent header/footer structure
4. Update footer links

## 🎯 Key Pages

### Home (index.html)
- Hero with full-screen image and CTAs
- Introduction section
- Feature cards (Stay, Eats, Wellness)
- Dining highlights
- Amenities showcase
- Call-to-action section

### Eats (eats.html)
- Overview of dining philosophy
- Three restaurant showcases with imagery
- Links to individual restaurant pages

### Stay (stay.html)
- Room categories (Deluxe, Executive, Signature, Penthouse)
- Image galleries
- Amenities lists
- Lightbox functionality

### Contact (contact.html)
- Validated contact form
- Contact information
- Map placeholder
- FAQ section

## 🔧 Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)

Uses modern CSS (Grid, Flexbox, Custom Properties) and ES6 JavaScript.

## ⚡ Performance

- **Optimized Images**: Uses Unsplash with quality parameters
- **Minimal JavaScript**: ~300 lines of vanilla JS
- **CSS Efficiency**: Single stylesheet with organized structure
- **No Dependencies**: No frameworks, no external libraries (except Google Fonts)
- **Fast Loading**: Minimal HTTP requests

## 📋 To-Do (Optional Enhancements)

- [ ] Integrate real map API (Google Maps, Mapbox)
- [ ] Add backend for contact form submission
- [ ] Implement actual reservation system
- [ ] Add image optimization/lazy loading for production
- [ ] Set up analytics tracking
- [ ] Add cookie consent banner
- [ ] Implement booking calendar
- [ ] Add multi-language support

## 📄 License

This is a demonstration project for Hotel Noesis. Modify as needed for your use case.

## 🙏 Credits

- **Design**: Custom luxury hotel design system
- **Fonts**: Google Fonts (Cormorant Garamond, Montserrat, Playfair Display)
- **Images**: Unsplash (for demonstration purposes - replace with actual hotel photography)
- **Icons**: Unicode symbols for decorative elements

## 📞 Support

For questions or issues with this template, please contact the development team.

---

**Hotel Noesis** - Where luxury hospitality meets distinguished design.

*Crafted with distinction. Built with care.*
